---
title: Envvar substitution
description: A Perl script to base64 encode strings and to substitute environment variables in a configuration file
keywords: envsubst, perl envsubst, base64 encode perl
publish: true
date: 2022-04-19
uuid: 252620ef-f882-47f6-a284-b624418b21ba
tags:
  - #kind/snippet
  - #language/perl
  - #topic/utilities
---

Embed this Perl snippet in your bash scripts to configure files based on environment variables!

<!-- More -->

```bash
#!/usr/bin/env bash
# Copyright 2022 Dario Balboni
# Code released under MIT License
#
perl -pe '
sub b64($) {
  my $bitstring = unpack("B*", $_[0]);
  my @sixs = unpack("(A6)*", $bitstring);
  my $padding = ((6 - (length $sixs[-1]) % 6) % 6);
  $sixs[-1] = join "", ($sixs[-1], "0" x $padding);
  my @enc = ("A".."Z", "a".."z", "0".."9", "+", "/");
  @sixs = map { unpack("c", pack("b6", join "", reverse(split "", $_))) } @sixs;
  my @s = map { $enc[$_] } @sixs;
  join "", (@s, "=" x ($padding / 2));
}
my $a = join("",<>) =~ s{\$\{(.*?)(\:-(.*?))?\}}{$ENV{$1}//$3//die "ENVVAR $1 NOT FOUND"}ger;
while ($a =~ m/\{\@((.|\s|\n)*?)\@\}/) {
  $a = $a =~ s{\{\@(((?!\{\@|\@\})(.|\s|\n))*)\@\}}{b64($1)}ger;
}
print $a;
' < input.yaml > output.yaml
```

The script first substitutes all environment variables having the syntax `${VARNAME}` or `${VARNAME:-DEFAULT}`, then recursively substitutes all fragments `{@inner@}`  with the base64 encoded representation of `inner`: `base64(inner)`.

Example input and output files:
```yaml
# input.yaml
unavailable: ${UNAVAILABLE:-N/A}
shell: ${SHELL}
encoded: {@{ "shell": "${SHELL}" }@}
```

```yaml
# output.yaml
unavailable: N/A
shell: /bin/bash
encoded: eyAic2hlbGwiOiAiL2Jpbi9iYXNoIiB9
```

Pretty cool, huh?
